/*
 * read a line into words
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "libfma.h"
#include "lf_stdio.h"

int any(char *, int);


void
line2words(
  char *buf,
  char **words,
  char *seps,
  int  wmax,
  int *wcnt)
{
  char        *wp;
  int          wc;

  if (wmax < 1 || wmax > LF_STRING_LEN) wmax = LF_STRING_LEN;

  wc = 0;
  wp = buf;
  while (wc < wmax && *wp != '\0') {
    while (any(seps, *wp)) ++wp;
    if (*wp == '\0') break;

    /* deal with a quoted word */
    if (*wp == '"') {
      ++wp;
      words[wc++] = wp;

      /* go until we hit a trailing " or end of string */
      while (!((*wp == '"' && (any(seps, wp[1]) || wp[1] == '\0')) ||
	       (*wp == '\0'))) ++wp;

      if (*wp != '\0') *wp++ = '\0';

    } else {

      words[wc++] = wp;
      while (!any(seps, *wp) && *wp != '\0') ++wp;
      if (wc < wmax && *wp != '\0') *wp++ = '\0';
    }
  }

  if (wcnt) *wcnt = wc;
  return;
}

void
line2words_nullok(
  char *buf,
  char **words,
  char *seps,
  int  wmax,
  int *wcnt)
{
  char        *wp;
  int          wc;

  if (wmax < 1 || wmax > LF_STRING_LEN) wmax = LF_STRING_LEN;

  wc = 0;
  wp = buf;
  while (wc < wmax && *wp != '\0') {

    /* deal with a quoted word */
    if (*wp == '"') {
      ++wp;
      words[wc++] = wp;

      /* go until we hit a trailing " or end of string */
      while (!((*wp == '"' && (any(seps, wp[1]) || wp[1] == '\0')) ||
	       (*wp == '\0'))) ++wp;

    } else {

      words[wc++] = wp;
      while (!any(seps, *wp) && *wp != '\0') ++wp;
    }

    if (wc < wmax && *wp != '\0') {
      *wp++ = '\0';
      if (*wp == '\0') {
	words[wc++] = wp;
	break;
      }
    }
  }

  if (wcnt) *wcnt = wc;
  return;
}

int any(
	char *s,
	int c)
{
	while (*s) if (*s++ == c) return 1;
	return 0;
}

/*
 * Get the next line of input, parsed into words, skipping blank lines
 * and lines beginning with '#'
 * The buffer and max words must be at least LF_STRING_LEN
 */
char *
lf_get_next_line(
  FILE *fp,
  char *buf,
  char **wp,
  int *wc)
{
  while (fgets(buf, LF_STRING_LEN, fp) != NULL) {

    /* skip blank lines and comments */
    if (buf[0] == '\0' || buf[0] == '\n' || buf[0] == '#') continue;

    /* break into words */
    line2words(buf, wp, "\n\t ", 0, wc);

    /* lines with only spaces are blank */
    if (*wc == 0) continue;

    return buf;
  }

  return NULL;
}

/*
 * Trim newlines and CRs from the end of a string
 */
void
lf_trim_nl(
  char *s)
{
  char *p;

  p = s + strlen(s) - 1;
  while ((p >= s) && (*p == '\n' || *p == '\r')) {
    --p;
  }
  p[1] = '\0';
}
